#include "stdafx.h"
#include "GetVersionInfo.h"
/*-----------------
     Major, Minor
98SE  4, 10
2000  5, 0
XP    5, 1
Vista 6, 0
7     6, 1
8     6, 2
8.1   6, 3
10    10, 0
---------------*/
void GetVersionInfo(int *pMajorVer, int *pMinorVer)
{
/*----------------
	TCHAR buf[256];
	TCHAR* osname;
	TCHAR* unknown;
	TCHAR* support;
	TCHAR* notsupport;

	UINT cp = GetOEMCP();	//	R[hy[W擾
	if (cp == 932) {	//	{ł̏ꍇ
		unknown = _TEXT("s");
		support = _TEXT("T|[g");
		notsupport = _TEXT("T|[g");
	}
	else {	//	{ňȊÓApŕ\
		unknown = _TEXT("unknown");
		support = _TEXT("support");
		notsupport = _TEXT("not support");
	}
-------------------*/
	EXTOSVERSIONINFOEX os;
	os.get();	//	Windowso[W̎擾
	*pMajorVer = os.dwMajorVersion;
	*pMinorVer = os.dwMinorVersion;

/*-----------------------------
	osname = os.getOSname();	//	Windows(7 vistaȂ)̎擾
	if (osname == 0) {
		osname = unknown;
	}
	_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), _TEXT("Windows %s\nMajorVersion %d\nMinorVersion %d\nBuild %d\n")
		_TEXT("ServicePack %d\nProductType 0x%.2x\nPlatformId 0x%.8x\nCSDVersion %s\nRtlGetVersion API %s\nGetVersionEX API %s"),
		osname, os.dwMajorVersion, os.dwMinorVersion, os.dwBuildNumber, os.wServicePackMajor, os.wProductType, os.dwPlatformId, os.szCSDVersion,
		os.RtlGetVersion_api == true ? support : notsupport,
		os.IsGetVersionEx() == true ? support : notsupport);

	MessageBox(0, buf, _TEXT("Windows Version"), MB_OK);
//	return (int)0;
--------------------------*/
}



#if _MSC_VER>=1800	//	Visual C++ 2013ȏ̏ꍇ
#include <VersionHelpers.h>
#endif


struct VER_TBL {	//	o[WԍOSƂ̈ꗗ
	DWORD major, minor;
	DWORD platform;
	BYTE  product;
	DWORD bulid;
	WORD  sp;
	struct {
		BYTE win9x : 2;	//	OSR̋ʖ9898SE̔ʂɎgp
		BYTE server2 : 1;	//	20032003R2̔ʂɎgp
		BYTE rev : 5;	//	\ς݂ƂȂ̒PȂrbǧ
	};
	TCHAR* name;
};

VER_TBL ver_tbl[] = {
	/*
	m   m  p  p  b s  w  s r   n
	a   i  l  r  u p  i  e e   a
	j   n  a  o  i    n  r v   m
	o   r  t  d  l    9  v     e
	r   r  f  c  d    x  e
	o  u          r
	r  t          2
	m
	*/
	{ 4, 0, 2, 0, 0,0,{ 0,0,0 }, OSNAME_NT4 },
	{ 4, 0, 1, 0, 0,0,{ 0,0,0 }, OSNAME_95 },
	{ 4, 0, 1, 0, 0,0,{ 0,1,0 }, OSNAME_95OSR1 },
	{ 4, 0, 1, 0, 0,0,{ 0,2,0 }, OSNAME_95OSR2 },
	{ 4, 0, 1, 0, 0,0,{ 0,3,0 }, OSNAME_95OSR25 },
	{ 4,10, 1, 0, 0,0,{ 0,0,0 }, OSNAME_98 },
	{ 4,10, 1, 0, 0,0,{ 1,0,0 }, OSNAME_98SE },
	{ 4,90, 1, 0, 0,0,{ 0,0,0 }, OSNAME_ME },
	{ 5, 0, 2, 1, 0,0,{ 0,0,0 }, OSNAME_2000 },
	{ 5, 0, 2, 3, 0,0,{ 0,0,0 }, OSNAME_2000_SERVER },
	{ 5, 1, 2, 1, 0,0,{ 0,0,0 }, OSNAME_XP },
	{ 5, 2, 2, 3, 0,0,{ 0,0,0 }, OSNAME_SERVER_2003 },
	{ 5, 2, 2, 3, 0,0,{ 0,1,0 }, OSNAME_SERVER_2003R2 },
	{ 6, 0, 2, 1, 0,0,{ 0,0,0 }, OSNAME_VISTA },
	{ 6, 1, 2, 1, 0,0,{ 0,0,0 }, OSNAME_7 },
	{ 6, 2, 2, 1, 0,0,{ 0,0,0 }, OSNAME_8 },
	{ 6, 3, 2, 1, 0,0,{ 0,0,0 }, OSNAME_81 },
	{ 6, 0, 2, 3, 0,0,{ 0,0,0 }, OSNAME_SERVER_2008 },
	{ 6, 1, 2, 3, 0,0,{ 0,0,0 }, OSNAME_SERVER_2008R2 },
	{ 6, 2, 2, 3, 0,0,{ 0,0,0 }, OSNAME_SERVER_2012 },
	{ 6, 3, 2, 3, 0,0,{ 0,0,0 }, OSNAME_SERVER_2012R2 },
	{ 6, 4, 2, 1, 9841,0,{ 0,0,0 }, OSNAME_WIN10_TP9841 },
	{ 6, 4, 2, 1, 9860,0,{ 0,0,0 }, OSNAME_WIN10_TP9860 },
	{ 6, 4, 2, 1, 9879,0,{ 0,0,0 }, OSNAME_WIN10_TP9879 },
	{ 10, 0, 2, 1, 9926,0,{ 0,0,0 }, OSNAME_WIN10_TP9926 },
	{ 10, 0, 2, 1,10041,0,{ 0,0,0 }, OSNAME_WIN10_TP10041 },
	{ 0, 0, 0, 0, 0,0,{ 0,0,0 }, 0 } };


//	Windows Version擾(GetVersionEx APȈ񂪎擾ł)

void EXTOSVERSIONINFOEX::get(void) {
	sm2 = 0;
	dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	LPOSVERSIONINFOEX lp = (LPOSVERSIONINFOEX)this;
	if (pGetVersionEx(lp) == 0) {
		dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		pGetVersionEx(lp);
	}

	BOOL f = GetVersion2((OSVERSIONINFOEX*)this);
	if (f == TRUE) {	//	VerifyVersionInfo APIT|[gĂꍇ Window2000ȍ~Windows2000GetVersionEx APIŎ擾
		RtlGetVersion_api = true;
		dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
		sm2 = GetSystemMetrics(SM_SERVERR2) ? 1 : 0;
		if (wServicePackMajor == 0)
			szCSDVersion[0] = _T('\0');
	}
}
//	WindowsOS擾(7VistaȂ)

TCHAR* EXTOSVERSIONINFOEX::getOSname(void) {
	int n = 0;
	DWORD p = wProductType;
	while (ver_tbl[n].major) {
		DWORD bp = ver_tbl[n].product;
		bool f;
		if (p == 2 && bp >= p)
			f = true;
		else if (p == 3 && bp == 3)
			f = true;
		else if (p == 1 && bp == 1)
			f = true;
		else if (p == 0 && bp == 0)
			f = true;
		else
			f = false;

		if (ver_tbl[n].major == dwMajorVersion &&
			ver_tbl[n].minor == dwMinorVersion &&
			f == true &&
			ver_tbl[n].platform == dwPlatformId &&
			ver_tbl[n].server2 == sm2)
		{
			if (Is9x()) { // Windows 9x̏ꍇ
				int win9x = 0;
				if (szCSDVersion[0] && szCSDVersion[2]) {
					win9x = szCSDVersion[1] - _TEXT('A') + 1;
				}
				if (ver_tbl[n].win9x == win9x) {
					return ver_tbl[n].name;
				}
			}
			else {
				if (ver_tbl[n].bulid == 0)
					return ver_tbl[n].name;
				else {
					if (ver_tbl[n].bulid == dwBuildNumber)
						return ver_tbl[n].name;
				}
			}
		}
		++n;
	}
	return 0;
}

//	osnameŎw肳ꂽWindows VersionNXɐݒ肵܂

void EXTOSVERSIONINFOEX::set(TCHAR* osname) {
	int n = 0;
	while (ver_tbl[n].major) {
		if (_tcscmp(ver_tbl[n].name, osname) == 0) {
			this->dwMajorVersion = ver_tbl[n].major;
			this->dwMinorVersion = ver_tbl[n].minor;
			this->dwPlatformId = ver_tbl[n].platform;
			this->wProductType = ver_tbl[n].product;
			this->sm2 = ver_tbl[n].server2;
			this->dwBuildNumber = ver_tbl[n].bulid;
			this->wServicePackMajor = ver_tbl[n].sp;
			this->wServicePackMinor = 0;
			szCSDVersion[0] = _T('\0');
			if (wServicePackMajor)
				_stprintf_s(szCSDVersion, sizeof(szCSDVersion) / sizeof(TCHAR), _TEXT("Service Pack %d"), wServicePackMajor);
			if (Is9x()) {
				if (ver_tbl[n].win9x)
					_stprintf_s(szCSDVersion, sizeof(szCSDVersion) / sizeof(TCHAR), _TEXT(" %c"), _T('A') + ver_tbl[n].win9x - 1);
			}
			return;
		}
		++n;
	}
}

BOOL GetVersion2(OSVERSIONINFOEX* os) {
	HMODULE hMod;
	RtlGetVersion_FUNC func;
#ifdef UNICODE
	OSVERSIONINFOEXW* osw = os;
#else
	OSVERSIONINFOEXW o;
	OSVERSIONINFOEXW* osw = &o;
#endif

	hMod = LoadLibrary(TEXT("ntdll.dll"));
	if (hMod) {
		func = (RtlGetVersion_FUNC)GetProcAddress(hMod, "RtlGetVersion");
		if (func == 0) {
			FreeLibrary(hMod);
			return FALSE;
		}
		ZeroMemory(osw, sizeof(*osw));
		osw->dwOSVersionInfoSize = sizeof(*osw);
		func(osw);
#ifndef	UNICODE
		os->dwBuildNumber = osw->dwBuildNumber;
		os->dwMajorVersion = osw->dwMajorVersion;
		os->dwMinorVersion = osw->dwMinorVersion;
		os->dwPlatformId = osw->dwPlatformId;
		os->dwOSVersionInfoSize = sizeof(*os);
		DWORD sz = sizeof(os->szCSDVersion);
		WCHAR* src = osw->szCSDVersion;
		unsigned char* dtc = (unsigned char*)os->szCSDVersion;
		while (*src)
			*dtc++ = (unsigned char)*src++;
		*dtc = '\0';
#endif

	}
	else
		return FALSE;
	FreeLibrary(hMod);
	return TRUE;
}
