#pragma once

#include <wtypes.h>
#include <winerror.h>

#include <mmdeviceapi.h>
#include <endpointvolume.h>
#include <FunctionDiscoveryKeys_devpkey.h>
#include <audioclient.h>
#include <audiopolicy.h>
//#include <vssym32.h>
#ifndef REFTIMES_PER_SEC

#define REFTIMES_PER_SEC  10000000
#define REFTIMES_PER_MILLISEC  10000

//#define REFTIMES_PER_SEC  44100
//#define REFTIMES_PER_MILLISEC  44

#define EXIT_ON_ERROR(hres)  \
              if (FAILED(hres)) { goto Exit; }
#define SAFE_RELEASE(punk)  \
              if ((punk) != NULL)  \
                { (punk)->Release(); (punk) = NULL; }


#endif

#define	MAX_DEV	30


class CAudioObj
{
public:
	int	ChangeSource(int nIndex);
	bool GetVolume(float * pfMaster, float * pfLeft, float * pfRight);
	bool SetChannelVolume(int nChannel, float fLevel);
	int SetMasterVolume(float fMaster);
	int InitObj(int nFlg);
	void ExitObj(void);
	CAudioObj(void);
	~CAudioObj(void);
	int	m_nDevCount;
	CString	m_DevName[MAX_DEV];

protected:
	void _GetDeviceName(IMMDevice *pDevice, CString *str);
	IMMDeviceEnumerator *m_pEnumerator;
	IMMDeviceCollection *m_pEndCollect;
	IMMDevice* m_pEndpoint[MAX_DEV];
	IAudioEndpointVolume	*m_pVolume;
	void SafeRelease(void);
};

