#include "StdAfx.h"
#include "stdapp.h"
#include "AudioObj.h"


CAudioObj::CAudioObj(void)
{
}

CAudioObj::~CAudioObj(void)
{
}



void CAudioObj::SafeRelease(void)
{
	int		i;

	for(i = 0; i < MAX_DEV; i++)
		SAFE_RELEASE(m_pEndpoint[i])
	SAFE_RELEASE(m_pEnumerator)
	SAFE_RELEASE(m_pVolume);
}

int CAudioObj::ChangeSource(int nIndex)
{
	HRESULT hr;
	SAFE_RELEASE(m_pVolume);
	hr = m_pEndpoint[nIndex]->Activate(__uuidof(IAudioEndpointVolume), CLSCTX_ALL, NULL, (void**)&m_pVolume);
	//ŃG[@Ǘ҃[hɂΖȂB
	if(FAILED(hr))
	{   
		AfxMessageBox(TEXT("Error"));
		return FALSE;   
	}
	return TRUE;
}


bool CAudioObj::GetVolume(float * pfMaster, float * pfLeft, float * pfRight)
{
	UINT		nNoOfChannel, i;

	float	fLevelScalar[10], fLevelScalar0;
	m_pVolume->GetChannelCount(&nNoOfChannel);
	for(i = 0; i < nNoOfChannel; i++)
		m_pVolume->GetChannelVolumeLevelScalar(i, &fLevelScalar[i]);
	m_pVolume->GetMasterVolumeLevelScalar(&fLevelScalar0);
	*pfMaster = fLevelScalar0;
	if(nNoOfChannel == 2)
	{
		*pfLeft = fLevelScalar[0];
		*pfRight = fLevelScalar[1];
	}
	else
		*pfLeft = *pfRight = *pfMaster;
	return TRUE;
}

bool CAudioObj::SetChannelVolume(int nChannel, float fLevel)
{
	m_pVolume->SetChannelVolumeLevelScalar(nChannel, fLevel, &GUID_NULL);
	return false;
}

int CAudioObj::SetMasterVolume(float fMaster)
{
	m_pVolume->SetMasterVolumeLevelScalar(fMaster, &GUID_NULL);
	return 0;
}


void CAudioObj::_GetDeviceName(IMMDevice *pDevice, CString	*str)
{
    static const WCHAR szDefault[] = L"<Device not available>";

    HRESULT hr = E_FAIL;
    IPropertyStore *pProps = NULL;
    PROPVARIANT varName;

    PropVariantInit(&varName);

    if (pDevice != NULL)
    {
        hr = pDevice->OpenPropertyStore(STGM_READ, &pProps);
        if (hr == S_OK)
            hr = pProps->GetValue(PKEY_Device_FriendlyName, &varName);
    }

    if (hr == S_OK)
		*str = varName.pwszVal;
    else
		*str = szDefault;

    PropVariantClear(&varName);
    SAFE_RELEASE(pProps);

    return;
}



int CAudioObj::InitObj(int nFlg)
	// nFlg 0:^@@PFĐ
{
	int		ret = -1;
	UINT		i;
//	CoInitializeEx(NULL, COINIT_MULTITHREADED);

	CoInitialize(NULL);
	m_pEnumerator = NULL;
	m_pEndCollect = NULL;
	for(i = 0; i < MAX_DEV; i++)
		m_pEndpoint[i] = NULL;
	m_pVolume = NULL;

	m_nDevCount = 0;
	HRESULT hr;
    // ANeBuȃLv`p̃Gh|Cg   
	hr = CoCreateInstance( 
		__uuidof(MMDeviceEnumerator), NULL,CLSCTX_ALL,
		__uuidof(IMMDeviceEnumerator),(void**)&m_pEnumerator);
	if( FAILED(hr) ){
		return -1;
	}
	IMMDevice* pDevice;
	CString	str, defstr;
	EDataFlow		nDev;
	if(nFlg == 0)
		nDev = eCapture;
	else
		nDev = eRender;
	hr = m_pEnumerator->GetDefaultAudioEndpoint(nDev, eConsole,	&pDevice);
	_GetDeviceName(pDevice, &defstr);

    m_pEnumerator->EnumAudioEndpoints(nDev, DEVICE_STATE_ACTIVE, &m_pEndCollect);   
	UINT count;   
	m_pEndCollect->GetCount(&count);
	m_nDevCount = count;
	for(i = 0; i < count; ++i) 
	{
		CComPtr<IMMDevice> pItem;
  
        m_pEndCollect->Item(i, &pItem);
		m_pEndpoint[i] = pItem;
		_GetDeviceName(pItem, &str);
		m_DevName[i] = str;
		if(defstr == str)
			ret = i;
    }  
	return ret;
}


void CAudioObj::ExitObj(void)
{
	SafeRelease();
	CoUninitialize();
}
