// AudioMixerDlg.cpp : t@C
//

#include "stdafx.h"
#include "stdapp.h"
//#include "AudioMixerDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedUrl();
	afx_msg void OnBnClickedEmail();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	ON_BN_CLICKED(IDC_URL, &CAboutDlg::OnBnClickedUrl)
	ON_BN_CLICKED(IDC_EMAIL, &CAboutDlg::OnBnClickedEmail)
	ON_WM_DRAWITEM()
END_MESSAGE_MAP()


// CAudioMixerDlg _CAO




CAudioMixerDlg::CAudioMixerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAudioMixerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAudioMixerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_ListBox);
	DDX_Control(pDX, IDC_SLIDER1, m_MainVolum);
	DDX_Control(pDX, IDC_SLIDER2, m_LeftVolum);
	DDX_Control(pDX, IDC_SLIDER3, m_RightVolum);
}

BEGIN_MESSAGE_MAP(CAudioMixerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_LBN_SELCHANGE(IDC_LIST1, &CAudioMixerDlg::OnLbnSelchangeList1)
	ON_WM_HSCROLL()
ON_WM_DESTROY()
ON_BN_CLICKED(IDC_CHANGE_DEV, &CAudioMixerDlg::OnBnClickedChangeDev)
ON_BN_CLICKED(IDC_INFO, &CAudioMixerDlg::OnBnClickedInfo)
ON_WM_TIMER()
END_MESSAGE_MAP()


// CAudioMixerDlg bZ[W nh

BOOL CAudioMixerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_MsgFlg = FALSE;
	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ
	CAudioMixerApp *pApp = (CAudioMixerApp *)AfxGetApp();

	// TODO: ɒǉ܂B
//	m_Obj.LoadMixer();
	pApp->m_nDevNo = m_Obj.InitObj(pApp->m_bRenderFlg);
	m_MainVolum.SetRange(0, 100);
	m_LeftVolum.SetRange(0, 100);
	m_RightVolum.SetRange(0, 100);

	InitListBox();
	GetDlgItem(IDC_LIST1)->EnableWindow(pApp->m_bAllFlg);
	SetWindowLongPtr(pApp->m_hCheckPrevWnd, GWLP_USERDATA, (LONG_PTR)pApp->m_pMainWnd->m_hWnd);
	SetButtonText();
	SetTimer(101, 333, NULL);
	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CAudioMixerDlg::OnBnClickedChangeDev()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	CAudioMixerApp *pApp = (CAudioMixerApp *)AfxGetApp();
	pApp->m_bRenderFlg = (pApp->m_bRenderFlg)? 0 : 1;
	m_Obj.ExitObj();
	pApp->m_nDevNo = m_Obj.InitObj(pApp->m_bRenderFlg);
	InitListBox();
	SetButtonText();
}

int CAudioMixerDlg::SetButtonText(void)
{
	CString	str;
	CAudioMixerApp *pApp = (CAudioMixerApp *)AfxGetApp();
	if(pApp->m_bRenderFlg)
		str = "Setting for recording";
	else
		str = "Setting for playing";
	SetDlgItemText(IDC_CHANGE_DEV, str);
	return 0;
}

int CAudioMixerDlg::InitListBox(void)
{
	CAudioMixerApp *pApp = (CAudioMixerApp *)AfxGetApp();
	m_ListBox.ResetContent();
	int		i;
	for(i = 0 ; i < m_Obj.m_nDevCount; i++)
		m_ListBox.InsertString(i, m_Obj.m_DevName[i]);
	m_ListBox.SetCurSel(pApp->m_nDevNo);
	OnLbnSelchangeList1();
	return 0;
}


void CAudioMixerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CAudioMixerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CAudioMixerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CAudioMixerDlg::OnLbnSelchangeList1()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int	nIndex = m_ListBox.GetCurSel();
	if(nIndex == -1)
		return;
	if(m_Obj.ChangeSource(nIndex))
	{
		float	fMaster, fLeft, fRight;
		m_Obj.GetVolume(&fMaster, &fLeft, &fRight);
		m_MainVolum.SetPos((int)(fMaster * 100.0F));
		m_LeftVolum.SetPos((int)(fLeft * 100.0F));
		m_RightVolum.SetPos((int)(fRight * 100.0F));
	}
}

void CAudioMixerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	int		nPos2;
	int	nIndex = m_ListBox.GetCurSel();
	if(nIndex == -1)
	{
		if(!m_MsgFlg)
		{
			m_MsgFlg = TRUE;
			AfxMessageBox("Select Item in ListBox.");
//			AfxMessageBox("Xg{bNX特ʂ𒲐߂鍀ڂIĂB");
			m_MsgFlg = FALSE;
		}
		return;
	}
	if(pScrollBar->m_hWnd == m_MainVolum.m_hWnd)
	{
		nPos2 = m_MainVolum.GetPos();
		m_Obj.SetMasterVolume((float)nPos2 / 100.0F);
	}
	else if(pScrollBar->m_hWnd == m_LeftVolum.m_hWnd)
	{
		nPos2 = m_LeftVolum.GetPos();
		m_Obj.SetChannelVolume(0, (float)nPos2 / 100.0F);
	}
	else if(pScrollBar->m_hWnd == m_RightVolum.m_hWnd)
	{
		nPos2 = m_RightVolum.GetPos();
		m_Obj.SetChannelVolume(1, (float)nPos2 / 100.0F);
	}
	float	fMaster, fLeft, fRight;
	m_Obj.GetVolume(&fMaster, &fLeft, &fRight);
	m_MainVolum.SetPos((int)(fMaster * 100.0F));
	m_LeftVolum.SetPos((int)(fLeft * 100.0F));
	m_RightVolum.SetPos((int)(fRight * 100.0F));

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}



void CAudioMixerDlg::OnDestroy()
{
	KillTimer(101);
	CDialog::OnDestroy();
	m_Obj.ExitObj();
	// TODO: ɃbZ[W nh R[hǉ܂B
}


void CAudioMixerDlg::OnBnClickedInfo()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}


void CAudioMixerDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B
	float	fMaster, fLeft, fRight;
	m_Obj.GetVolume(&fMaster, &fLeft, &fRight);
	m_MainVolum.SetPos((int)(fMaster * 100.0F));
	m_LeftVolum.SetPos((int)(fLeft * 100.0F));
	m_RightVolum.SetPos((int)(fRight * 100.0F));

	CDialog::OnTimer(nIDEvent);
}


void CAboutDlg::OnBnClickedUrl()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	CString	str;
	char	*ptr;
	GetDlgItemText(IDC_URL, str);
	ptr = str.GetBuffer(256);
	ShellExecute( NULL, NULL, ptr, NULL, NULL, SW_SHOWNORMAL );
}


void CAboutDlg::OnBnClickedEmail()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	CString	str, str2;
	char	*ptr;
	GetDlgItemText(IDC_EMAIL, str);
	str2 = "mailto:" + str;
	ptr = str2.GetBuffer(256);
	ShellExecute( NULL, NULL, ptr, NULL, NULL, SW_SHOWNORMAL );	
}


void CAboutDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B
	LPDRAWITEMSTRUCT lpdis;
	CFont	Font, *pFont;
	CString	str;
	CDC	dc;
	GetDlgItemText(nIDCtl, str);
	lpdis = lpDrawItemStruct;
	dc.Attach(lpdis->hDC);
	dc.SetMapMode(MM_TEXT );
	Font.CreateFont(-MulDiv(9, GetDeviceCaps(lpdis->hDC, LOGPIXELSY), 72) , 0, 0, 0,
					FW_DONTCARE, 0, TRUE, 0, 0, 0, 0, 0, 0, "Arial");
	pFont = dc.SelectObject(&Font);
	dc.SetTextColor(( lpdis->itemAction & ODA_SELECT && lpdis->itemState & ODS_SELECTED ?
				RGB(255,0,0) : RGB(0,0,255) )); // }EXNbN͐ԐFŕ\
	dc.SetBkColor(GetSysColor(COLOR_3DFACE));
	dc.DrawText(str, -1, &(lpdis->rcItem), DT_WORDBREAK | DT_NOPREFIX | DT_LEFT | DT_EDITCONTROL );
	dc.SelectObject(pFont);
	dc.Detach();

	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}


BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
#ifdef _X64_
	SetDlgItemText(IDC_CPU_BIT, "64bit edition");
#endif	
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void OutputDebugStringFile(CString str1)
{

	char	*str = str1.GetBuffer(256);
	int		len;
	CFile	file;
	if(str1 == "clear")
	{
		file.Open("DEBUG.csv", CFile::modeCreate | CFile::modeWrite);
		file.Close();
	}
	else
	{
		file.Open("DEBUG.csv", CFile::modeWrite | CFile::shareDenyNone);
		file.Seek(0, CFile::end);
		len = (int)strlen(str);
		file.Write(str, len);
		file.Close();
	}
	str1.ReleaseBuffer();
}

